/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.desertmobs.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupAlpha;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowParent;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetParent;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.DropRate;
import com.lycanitesmobs.desertmobs.entity.EntityJoust;
import java.util.HashMap;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityJoustAlpha
extends EntityCreatureAgeable
implements IAnimals,
IGroupAlpha {
    public EntityJoustAlpha(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.defense = 1;
        this.experience = 5;
        this.hasAttackSound = true;
        this.setWidth = 0.9f;
        this.setHeight = 2.2f;
        this.attackTime = 10;
        this.setupMob();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee(this).setRate(10).setLongMemory(false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent(this).setSpeed(1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityJoustAlpha.class));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPrey.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPredator.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetParent(this).setSightCheck(false).setDistance(32.0));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 20.0);
        baseAttributes.put("movementSpeed", 0.32);
        baseAttributes.put("knockbackResistance", 0.25);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 3.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("joustmeatraw")), 1.0f).setBurningDrop(new ItemStack(ObjectManager.getItem("joustmeatcooked"))).setMinAmount(3).setMaxAmount(7));
    }

    @Override
    public float getBlockPathWeight(int x, int y, int z) {
        IBlockState blockState = this.field_70170_p.func_180495_p(new BlockPos(x, y - 1, z));
        if (blockState.func_177230_c() != Blocks.field_150350_a) {
            if (blockState.func_185904_a() == Material.field_151595_p) {
                return 10.0f;
            }
            if (blockState.func_185904_a() == Material.field_151571_B) {
                return 7.0f;
            }
            if (blockState.func_185904_a() == Material.field_151576_e) {
                return 5.0f;
            }
        }
        return super.getBlockPathWeight(x, y, z);
    }

    public void func_70624_b(EntityLivingBase entity) {
        if (entity == null && this.func_70638_az() instanceof EntityJoustAlpha && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i((this.func_110138_aP() - this.func_110143_aJ()) / 2.0f);
            this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200, 2, false, true));
        }
        super.func_70624_b(entity);
    }

    @Override
    public boolean isDamageTypeApplicable(String type) {
        if (type.equals("cactus")) {
            return false;
        }
        return super.isDamageTypeApplicable(type);
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76438_s) {
            return false;
        }
        if (potionEffect.func_188419_a() == MobEffects.field_76437_t) {
            return false;
        }
        return super.func_70687_e(potionEffect);
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable partener) {
        return new EntityJoust(this.field_70170_p);
    }
}

